%   My first MatLab attempt, to swallow data as produced by Gnash's DUMP
% command in a comma-separated format. There are two header lines, the first
% having a list of names for the columns, the second a list of titles. Then
% follows the mass of data, 17568 lines to a (leap) year. For example:
%"Aux.Date","Aux.HHn","Aux.DayClock","Aux.Sun","Aux.DayClass","B"
%"Date.","Half-hour number of the day.","Days since Sunday, 31'st December 1899.","Solar Altitude in Degrees at Mt. Cook Trig, Wellington.","Day Class.","Blenheim"
%01/04/1981, 1  ,29676.0104,-52.87, 3,   9744.0
%01/04/1981, 2  ,29676.0312,-52.68, 3,   9120.0
%01/04/1981, 3  ,29676.0521,-51.30, 3,   8640.0
% and so on to the end of the day
%01/04/1981,48  ,29676.9896,-52.25, 3,  10704.0
%02/04/1981, 1  ,29677.0104,-53.26, 4,   9744.0
% etc.

%   Activate via
%	GnashFile = 'filename.csv';	%Specify the name of the file to read.
%	Gnash;				%Note that case counts; thus not "gnash".
%   The result will be the creation of variables
%	NCols, NRows,			-describing the sizes.
%	GnashNames, GnashTitles,	-from the header lines.
%	GnashData,			-The data.
%       plus a collection of variables based on the names found in
% the header, in structures corresponding to the name structures, if any,
% being in their aggregate a copy of GnashData, but structured, somewhat.
%   There is scant checking, and less provision for possible mishaps. The
% data files to be read are computer-prepared, and so should be in good
% order...

%   This should be a function, so that the file name is a parameter, but
% variables created within a function vanish when the function exits, or, 
% if the "Global" feature of MatLab is tried, they have to be named both
% outside and inside the function, and in this case the names are not known
% until after the file is read. There may be hundreds.
%   What is wanted is a "macro" facility which behaves as a function with
% parameters, but runs at the same level as the invocation, and thus can
% create variables that the caller can use.
%   A more practised twiddler of MatLab might be able to do better, but
% this will do for now.
%   Concocted by R.N.McLean (whom God preserve), 19'th May MMV.

GnashIn = fopen(GnashFile,'r');	%Here we go for the file to read...
if GnashIn  < 0			%Perhaps not with success.
 disp(['Try some other value for GnashFile! I Can''t grab file ',GnashFile]);	%Oh well.
 return;			%Give up.
end;		%So much for a token check.
disp(['First, feel the head of file ',GnashFile]);	%Phrenology.
GnashContents = strread(fgetl(GnashIn),'%q','delimiter',',');
GnashNames = strread(fgetl(GnashIn),'%q','delimiter',',');	%Comma-separated quoted strings.
GnashTitles = strread(fgetl(GnashIn),'%q','delimiter',',');	%Double quotes, not apostrophes.
NCols = size(GnashNames,1);			%So, how did that go?
disp(['Number of columns: ' int2str(NCols)]);	%Announce.
if NCols ~= size(GnashTitles,1)		%A token check.
 disp([' but the number of columns in GnashTitles is ',int2str(size(GnashTitles,1))]);
end;
%   Pander to some problems matlab has with structure names.
%   A name such as X.Y is acceptable to matlab, but X.666 is not.
% So, insert the letter v as a prefix to such digits. 
%   Secondly, if X.Y is a name, matlab dislikes the use of X as a name in
% the same way also since X is to be the name of the collective in its view...
% Accordingly, the name X is to be changed to X.itself, in the hope that no
% such name will be supplied by the input data. Since matlab distinguishes
% between capitals and lowercase in names, and I expect that most name parts
% will start with a capital, all should be safe, if potentially confusing and
% vexing. As to the means of identifying such names, Gnash supplies the
% names in sorted order (except for the "Aux" names at the start, which
% don't have this problem), treating lower case characters as capitals,
% thus a name X will be followed by X.Y and so the troublesome condition can
% be recognised by comparing names pairwise.
GnashNamesOriginal = GnashNames;	%Some fiddles impend.
for i = 0:9	%Try every possible digit. I'm adrift in multiple matlab twiddle routines.
 GnashNames = strrep(GnashNames,['.',int2str(i)],['.v',int2str(i)]);    %Crude, but I'm irked.
end;		%So "Albany.110KV" becomes "Albany.v110KV", alas...
if ~isequal(GnashNamesOriginal,GnashNames)	%Any change?
 disp('Alas, matlab dislikes name parts starting with a digit. I supply a "v" prefix for such...');	%Sigh.
end;		%Crude detection of deeds.
clear GnashNamesOriginal;	%Discard the hired help.
for i = 2:NCols	%Level tangles. If there is a "Fred.x" a "Fred" is not allowed.
 l = size(GnashNames{i - 1},2) + 1;	%It is known that the names are in sorted order.
 if strncmpi([GnashNames{i - 1},'.'],GnashNames{i},l)	%Miscegnation? The "i" sez "ignore case".
  disp(['Alas, names ',GnashNames{i - 1},' and ',GnashNames{i},' can''t co-exist in matlab, so I append ".itself"']);	%Sigh.
  GnashNames{i - 1} = [GnashNames{i - 1},'.itself'];	%Yes. The parent came first.
 end;		%Thus, any "Fred" (followed by "Fred.x") becomes a "Fred.itself".
end;	%And on to the next.
  
%Confront the data. Swallow everything into GnashData.  
l = 0;		%I want the maximum length of the names.
for i = 1:NCols	%But I can't guess how to ask.
 l = max(l,size(GnashNames{i},2));	%So, one by one.
end;			%And on to the next.
disp(['Column, Name',blanks(l - 9),'~ Title']);	%A heading.
idiot = '';		%A scratchpad. 
for i = 1:NCols		%Prepare a "format", without benefit of repetition counts.
 disp([num2str(i,6),' ',GnashNames{i},blanks(l - size(GnashNames{i},2)),' ~ ',GnashTitles{i}]);	%On the way, announce the name and title.
 if strcmp(GnashNames(i),'Aux.Date')	%There is no format code for a date, damnit...
   idiot = strcat(idiot,'%s');	%So treat as a "string".
  else				%But otherwise,
   idiot = strcat(idiot,'%f');	%Expect a number.
 end;			%So much for that format.
end;		%On to the next.
disp(['Now, chew into the body of file ',GnashFile]);	%Here we go!
GnashData = textscan(GnashIn,idiot,'delimiter',',','treatAsEmpty','?');	%Slurp!
fclose(GnashIn); clear GnashIn;	%Presume success.
NRows = size(GnashData{1},1);	%How much success?
disp(['Burp! Number of rows: ' int2str(NRows)]);	%Announce.
if NCols ~= size(GnashData,2)	%Another check.
  disp([' but the number of columns in GnashData is ',int2str(size(GnashData,2))]);	%Huh?
end;		%Token check for coherence.
GnashArray=zeros(NRows,NCols); %allocate storage for array version of the data (BCS modification 15/8/2005)

%Extract the cargo from GnashData, creating names as per GnashNames.
for i = 1:NCols		%Step along the columns.
 if strcmp(GnashNames(i),'Aux.Date')	%The troublemaker?
   disp(['Converting column ',int2str(i),' from a text date to a MatLab day number.']);	%Yes.
   GnashData{i} = datenum(GnashData{i},'dd/mm/yyyy');	%This accommodates d/m/yyyy variants as well.
   disp('"All is number" - Pythagoras.');	%But, what is "number"?
 end;		%So much for the special case.
 if strcmp(GnashNames(i),'Aux.DayClock')	%Now, another nusiance.
   l = datenum(1899,12,31);	%Gnash reckons 1/1/1900 as day one.
   if l ~= 0			%But matlab uses something wierd.
    idiot = ['Gnash uses 31/12/1899, a Sunday, as day zero but matlab numbers it ',int2str(l),'. So, a re-base'];	%Grr.
    if mod(l,7) == 0		%An additional consideration.
      idiot = [idiot,'.'];	%Perhaps not offended.
    else			%But actually, I know it is.
      idiot = [idiot,', even though (',int2str(l),' mod 7) is not zero.'];	%Grr!
    end;			%So much for my disfavour.
    disp(idiot);		%Express it.
    GnashData{i} = GnashData{i} + l;	%Some shift or other.
   end;			%So much for the date shift.
 end;		%So much for the fiddles.
 GnashArray(:,i)=GnashData{i}; %put the data into a 2D array (BCS modification 15/8/2005) ...
end;			%And on to the next.

%Completed: clear my tracks.
clear idiot i l;	%A large programme.
disp(['So much for ',GnashFile]);	%Farewell.
clear GnashData     % (BCS modification 15/8/2005)